/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationInformationHiding;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Product {

    //These are the properties that EVERY product has.
    private String name;
    private String brand;
    private Description description = new Description();
    private String colour;
    private double price;

    //Getter and Setter for colour
    public void setColour(String colour) {
        switch (colour) {
            case "Red":
            case "Blue":
            case "Black":
            case "Green":
                this.colour=colour;
                break;
            default:
                System.out.println("The products colour must be either Red, Blue, Black or Green");
        }
    }
    public String getColour(){
        return this.colour;
    }

    public void enterDescription(String comment, String country, int height, int weight) {
        //Populate the fields
        this.description.comments = comment;
        this.description.country = country;
        this.description.height = height;
        this.description.weight = weight;
    }

    public void enterDescription(String comment) {
        //Construct a new description and add it to this class.
        Description newDescription = new Description();

        //Populate the fields
        newDescription.comments = comment;

        //Add it to this class
        this.description = newDescription;
    }

    //This method will be used whenever anyone want to print out the details of a product.
    public void printProduct() {
        //Print out Name, Description and Price
        System.out.println("Name: " + getName());
        System.out.println("Description: " + getDescription());
        System.out.println("Price: " + getPrice());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getDescription() {
        return description.comments
                +" Country: "+description.country
                +" Height: "+description.height
                +" Weight: "+description.weight;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

}
